# -*- coding: utf-8 -*- 
# http://scipy-lectures.github.com


#---------------------------------------------------
#Import důležitých součástí
#---------------------------------------------------
import numpy as np
import scipy as sp
import pylab as plt
from scipy import signal
import matplotlib as mat
import random as rand       # modul pro generování náhodného čísla ze zvoleného intervalu


#---------------------------------------------------------------------------
# Funkce pro vytvoření masky bunky
#---------------------------------------------------------------------------
def TvorbaMasky(BunkaProMasku):
    Maska = np.empty_like(BunkaProMasku)        # Vytvoříme pole o rozměrech "zorného pole bunky"
    Maska[BunkaProMasku>0.0] = 1.0              # Místa, kde bunka leží nahradíme 1
    Maska[BunkaProMasku<=0.0] = 0.0             # Místa, kde bunka není nahradíme 0
    return Maska                                # Výstupem funkce je maska - bílé body v místech bunky na černém pozadí

#---------------------------------------------------------------------------
# Funkce pro vážení bunky (zatím na černém pozadí)
#---------------------------------------------------------------------------
def HmotnostBunky(Bunka, Maska):
    Hmotnosti = Bunka * Maska
    Hmotnost = np.sum(Hmotnosti)
    return Hmotnost


